/*
 * @(#)ZipToolsBar.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import java.io.File;
import java.awt.FlowLayout;
import com.sun.java.swing.JPanel;


/**
 * Class used to create the toolbar
 * @see ZipButton
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipToolsBar extends JPanel {
    
    // private members
    private ZipButton NewButton;
    private ZipButton OpenButton;
    private ZipButton ExtractButton;
    private ZipButton AddButton;
    private ZipButton AboutButton;

    /**
     * Class Constructor
     * @param allActionListener the global actionlistener
     */
    public ZipToolsBar(AllActionListener allActionListener) {
	
	// create all buttons
	NewButton = new ZipButton("New","images" + File.separator + "new.gif");
	OpenButton = new ZipButton("Open","images" + File.separator + "open.gif");
	ExtractButton = new ZipButton("Extract","images" + File.separator + "extract.gif");
	AddButton = new ZipButton("Add","images" + File.separator + "add.gif");
	AboutButton = new ZipButton("About","images" + File.separator + "about_b.gif");
	
	// set up the buttons
	NewButton.setToolTipText("Create a new archive");
	OpenButton.setToolTipText("Open an archive");
	ExtractButton.setToolTipText("Extract files from archive");
	AddButton.setToolTipText("Add files to archive");
	AboutButton.setToolTipText("About the program");
	NewButton.addActionListener(allActionListener);
	OpenButton.addActionListener(allActionListener);
	ExtractButton.addActionListener(allActionListener);
	AddButton.addActionListener(allActionListener);
	AboutButton.addActionListener(allActionListener);
	ExtractButton.setButtonEnabled(false);
	AddButton.setButtonEnabled(false);

	// set up the JPanel
	setLayout(new FlowLayout(FlowLayout.LEFT));
	add(NewButton);
	add(OpenButton);
	add(ExtractButton);
	add(AddButton);
	add(AboutButton);
    }

    /**
     * Method used to enable the Action and Edit button
     * @param flag true if enable
     */
    public void setEnabledButtons(boolean flag) {
	ExtractButton.setButtonEnabled(flag);
	AddButton.setButtonEnabled(flag);
    }
}

